import os
import json
from typing import Dict
__all__ = ["SimpleReporter"]


class SimpleReporter(object):
    def __init__(
            self,
            experiment_dir: str,
            cfg: Dict
    ):
        self.name = os.path.join(experiment_dir, "reporter.json")
        self.out = {
            **cfg,
            "checkpoint": []}
        self.write()

    def __call__(self, metrics: dict):
        self.report(metrics)

    def write(self):
        with open(self.name, mode="w") as f:
            json.dump(self.out, f, ensure_ascii=False, indent=4)

    def report(self, metrics: dict):
        self.out["checkpoint"].append(metrics)
        self.write()

